<?php
use yii\helpers\Url;
use common\models\Bots;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;

return [
    /*[
        'class' => 'kartik\grid\CheckboxColumn',
        'width' => '20px',
    ],*/
    [
        'class' => 'kartik\grid\SerialColumn',
        'width' => '30px',
    ],
        // [
        // 'class'=>'\kartik\grid\DataColumn',
        // 'attribute'=>'id',
    // ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'login',
    ],
    /*[
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'password_hash',
    ],*/
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'role',
        'contentOptions' => ['class' => 'text-left', 'style' => 'min-width:50px;'],
        'value' => function ($model) {
            if($model->role == 0){
                return 'User';
            } elseif($model->role == 10){
                return 'QA (Quality Assurance)';
            } elseif($model->role == 20){
                return 'Superadmin';
            }
        },
        'filterType' => \kartik\grid\GridView::FILTER_SELECT2,
        'filter' => [ // offline, not_valid, key_lock, ad_no, ad_yes
            null => 'All',
            0 => 'User',
            1 => 'QA (Quality Assurance)',
            2 => 'Superadmin',
        ],
    ],
    [
        'class'=>'\kartik\grid\DataColumn',
        'attribute'=>'status',
        'contentOptions' => ['class' => 'text-left', 'style' => 'min-width:50px;'],
        'value' => function ($model) {
            if($model->status == 0){
                return 'Inactive';
            } elseif($model->status == 1){
                return 'Active';
            }
        },
        'filterType' => \kartik\grid\GridView::FILTER_SELECT2,
        'filter' => [ // offline, not_valid, key_lock, ad_no, ad_yes
            null => 'All',
            0 => 'Inactive',
            1 => 'Active',
            
        ],
    ],
    [
        'attribute' => 'groups',
        'contentOptions' => ['class' => 'text-left', 'style' => 'min-width:70px;'],
        'value' => function ($model) {
            $_ = $model->groups;
            if($_ == null){
                $a = [];
            }else{
                $a = json_decode($model->groups);
            }
            
            $b = '';
            $c = ', ';
            for($i = 0; $i < count($a); $i++) {
                if($i == count($a)-1){
                    $c = '';
                }
                $b .= $a[$i] . $c;
            }
            return $b;
        }
        
    ],
    [
        'class' => 'kartik\grid\ActionColumn',
        'dropdown' => false,
        'vAlign'=>'middle',
        'template' => '{update} {delete}',
        'urlCreator' => function($action, $model, $key, $index) { 
                return Url::to([$action,'id'=>$key]);
        },
        'viewOptions'=>['role'=>'modal-remote','title'=>'View'],
        'updateOptions'=>['role'=>'modal-remote','title'=>'Update'],
        /*'deleteOptions'=>['role'=>'modal-remote','title'=>'Delete', 
                          'data-confirm'=>false, 'data-method'=>false,// for overide yii data api
                          'data-request-method'=>'post',
                          'data-confirm-title'=>'Are you sure?',
                          'data-confirm-message'=>'Are you sure want to delete this item'],*/ 
    ],

];   